/*
Collision Mask Utilities
Copyright ©2014 David Powell

Released under the MIT Licence

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef MASK_H
#define MASK_H

#include <QtGlobal>
#include <QString>
#include <QVarLengthArray>
#include <QByteArray>
#include <QFile>
#include <QtEndian>
#include <QDataStream>

#include <stdexcept>

/*!
 * \brief The Mask class
 */
class Mask
{
private:
    static const quint8 signature[10];
    static const quint32 VersionOffset = 10;
    static const quint32 DataOffsetOffset = 14;
    static const quint32 DataLengthOffset = 18;
    static const quint32 WidthOffset = 22;
    static const quint32 HeightOffset = 26;

public:
    quint32 width;
    quint32 height;
    QByteArray data;

public:
    Mask();
    void load(QString filename);

private:
    bool checkSignature(QByteArray maskData);
    QByteArray rleDecode(QByteArray maskData, quint32 index, quint32 length, quint32 decodedLength);
    quint32 calculateCrc32(QByteArray data, quint32 previousCrc32 = 0);
};

#endif // MASK_H
